import misc.Debug;
import sampling.Watcher;
import sampling.BaseSampler;
import java.applet.Applet;
import java.awt.Image;
import java.awt.Toolkit;

import java.awt.Frame;
import java.awt.Component;
import java.awt.MediaTracker;

class Global extends java.lang.Object {
    public static boolean m_bIsApplet=true;   // True -> running as Applet
    public static Component m_Component;      // Reference to the Applications applet
    public static Watcher watcher;
    public static SlidingWindowSampler sampler;
    // Images
    public static Image senderImage;
    public static Image receiverImage;
    public static Image m_imgChannel;
    public static Image m_imgClock;
    public static Image m_imgSendSpeed;
    public static Image m_imgReceiveSpeed;
    public static Image m_imgBlitz;
    public static Image m_imgAbout;
    // The two Stations...
    public static Computer sender;
    public static Computer receiver;
    // connected with one Channel
    public static Channel  channel;
    // communicating with a instance of Protocol for each
    public static SimpleProtocol senderProtocol;
    public static SimpleProtocol receiverProtocol;
    // Frames generated by Stimuli
    public static HistoryPanel historyPanel;
    // Dialog for computer setup
    public static ComputerProperties m_dlgComputerProperties;

    public static void init(Component component) {
        m_Component = component;
        // Create graphic Objects
        Debug.out("Loading Images...");
        if (m_bIsApplet) {
            Applet app = (Applet)m_Component;
            MediaTracker mt = new MediaTracker(app);
            senderImage = app.getImage(app.getCodeBase(),"sender.jpg");
            receiverImage = app.getImage(app.getCodeBase(),"receiver.jpg");
            m_imgChannel = app.getImage(app.getCodeBase(),"channel.gif");
            m_imgClock = app.getImage(app.getCodeBase(),"clock.gif");
            m_imgBlitz = app.getImage(app.getCodeBase(),"blitz.gif");
            m_imgAbout = app.getImage(app.getCodeBase(),"about.gif");
            m_imgSendSpeed = app.getImage(app.getCodeBase(),"SS.gif");
            m_imgReceiveSpeed = app.getImage(app.getCodeBase(),"RS.gif");
            mt.addImage(senderImage,0);
            mt.addImage(receiverImage,1);
            mt.addImage(m_imgChannel,2);
            mt.addImage(m_imgClock,3);
            mt.addImage(m_imgBlitz,4);
            mt.addImage(m_imgAbout,5);
            mt.addImage(m_imgSendSpeed,6);
            mt.addImage(m_imgReceiveSpeed,7);
            try {
                mt.waitForID(0);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(1);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(2);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(3);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(4);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(5);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(6);
            }
            catch(InterruptedException e) {};
            try {
                mt.waitForID(7);
            }
            catch(InterruptedException e) {};
        }
        else {
            Applet app = (Applet)m_Component;
            MediaTracker mt = new MediaTracker(app);
            senderImage = Toolkit.getDefaultToolkit().getImage("sender.jpg");
            receiverImage = Toolkit.getDefaultToolkit().getImage("receiver.jpg");
            m_imgChannel = Toolkit.getDefaultToolkit().getImage("channel.gif");
            m_imgClock = Toolkit.getDefaultToolkit().getImage("clock.gif");
            m_imgBlitz = Toolkit.getDefaultToolkit().getImage("blitz.gif");
            m_imgAbout = Toolkit.getDefaultToolkit().getImage("about.gif");
            m_imgReceiveSpeed = Toolkit.getDefaultToolkit().getImage("RS.gif");
            m_imgSendSpeed = Toolkit.getDefaultToolkit().getImage("SS.gif");               mt.addImage(senderImage,0);
            mt.addImage(receiverImage,1);
            mt.addImage(m_imgChannel,2);
            mt.addImage(m_imgClock,3);
            mt.addImage(m_imgBlitz,4);
            mt.addImage(m_imgAbout,5);
            mt.addImage(m_imgSendSpeed,6);
            mt.addImage(m_imgReceiveSpeed,7);
	    try {
	      mt.waitForAll();
	    }
	    catch (InterruptedException e) {};
       }

        // Create the physical Object
        Debug.out("Creating Computers");
        sender = new Computer();
        receiver = new Computer();
        channel = new Channel();

        // Create the corresponding threads
        Debug.out ("Creating corresponding threads");
        senderProtocol = new SimpleProtocol(sender);
        receiverProtocol = new SimpleProtocol(receiver);

        // Configure bindings
        Debug.out ("Configuring bindings...");
        sender.init(senderImage,channel,senderProtocol);
        receiver.init(receiverImage,channel,receiverProtocol);
        channel.init(m_imgChannel,sender,receiver);

        // create Computer properties dialog
		Frame frame = new Frame();
   		m_dlgComputerProperties = new ComputerProperties(frame);
		m_dlgComputerProperties.setResizable(true);
        m_dlgComputerProperties.resize(300,390);
		m_dlgComputerProperties.setResizable(false);

        // create & set panels
        Debug.out("Creating Panels...");
        sender.panel(new SenderPanel(sender));
        receiver.panel(new ReceiverPanel(receiver));
        channel.panel(new ChannelPanel(channel));
        historyPanel = new HistoryPanel();

        Debug.out("Creating sampler & watcher ...");
        watcher = new Watcher("SlidingWindowWatcher");
        sampler = new SlidingWindowSampler();
    }
}

